<!--
Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.

SPDX-License-Identifier: curl
-->

# Mail etiquette

## About the lists

### Mailing Lists

The mailing lists we have are all listed and described on the [curl
website](https://curl.se/mail/).

Each mailing list is targeted to a specific set of users and subjects, please
use the one or the ones that suit you the most.

Each mailing list has hundreds up to thousands of readers, meaning that each
mail sent is received and read by a large number of people. People from
various cultures, regions, religions and continents.

### Netiquette

Netiquette is a common term for how to behave on the Internet. Of course, in
each particular group and subculture there are differences in what is
acceptable and what is considered good manners.

This document outlines what we in the curl project consider to be good
etiquette, and primarily this focus on how to behave on and how to use our
mailing lists.

### Do Not Mail a Single Individual

Many people send one question to one person. One person gets many mails, and
there is only one person who can give you a reply. The question may be
something that other people would also like to ask. These other people have no
way to read the reply, but to ask the one person the question. The one person
consequently gets overloaded with mail.

If you really want to contact an individual and perhaps pay for his or her
services, by all means go ahead, but if it is just another curl question, take
it to a suitable list instead.

### Subscription Required

All curl mailing lists require that you are subscribed to allow a mail to go
through to all the subscribers.

If you post without being subscribed (or from a different mail address than
the one you are subscribed with), your mail is simply silently discarded. You
have to subscribe first, then post.

The reason for this unfortunate and strict subscription policy is of course to
stop spam from pestering the lists.

### Moderation of new posters

Several of the curl mailing lists automatically make all posts from new
subscribers be moderated. After you have subscribed and sent your first mail
to a list, that mail is not let through to the list until a mailing list
administrator has verified that it is OK and permits it to get posted.

Once a first post has been made that proves the sender is actually talking
about curl-related subjects, the moderation "flag" is switched off and future
posts go through without being moderated.

The reason for this moderation policy is that we do suffer from spammers who
actually subscribe and send spam to our lists.

### Handling trolls and spam

Despite our good intentions and hard work to keep spam off the lists and to
maintain a friendly and positive atmosphere, there are times when spam and or
trolls get through.

Troll - "someone who posts inflammatory, extraneous, or off-topic messages in
an online community"

Spam - "use of electronic messaging systems to send unsolicited bulk messages"

No matter what, we NEVER EVER respond to trolls or spammers on the list. If
you believe the list admin should do something in particular, contact them
off-list. The subject is taken care of as much as possible to prevent repeated
offenses, but responding on the list to such messages never leads to anything
good and only puts the light even more on the offender: which was the entire
purpose of it getting sent to the list in the first place.

Do not feed the trolls.

### How to unsubscribe

You can unsubscribe the same way you subscribed in the first place. You go to
the page for the particular mailing list you are subscribed to and you enter
your email address and password and press the unsubscribe button.

Also, the instructions to unsubscribe are included in the headers of every
mail that is sent out to all curl related mailing lists and there is a footer
in each mail that links to the "admin" page on which you can unsubscribe and
change other options.

You NEVER EVER email the mailing list requesting someone else to take you off
the list.

### I posted, now what?

If you are not subscribed with the same email address that you used to send
the email, your post is silently discarded.

If you posted for the first time to the mailing list, you first need to wait
for an administrator to allow your email to go through (moderated). This
normally happens quickly but in case we are asleep, you may have to wait a few
hours.

Once your email goes through it is sent out to several hundred or even
thousands of recipients. Your email may cover an area that not that many
people know about or are interested in. Or possibly the person who knows about
it is on vacation or under a heavy work load right now. You may have to wait
for a response and you should not expect to get a response at all. Ideally,
you get an answer within a couple of days.

You do yourself and all of us a service when you include as many details as
possible already in your first email. Mention your operating system and
environment. Tell us which curl version you are using and tell us what you
did, what happened and what you expected would happen. Preferably, show us
what you did with details enough to allow others to help point out the problem
or repeat the steps in their locations.

Failing to include details only delays responses and make people respond and
ask for more details and you have to send follow-up emails that include them.

Expect the responses to primarily help YOU debug the issue, or ask YOU
questions that can lead you or others towards a solution or explanation to
whatever you experience.

If you are a repeat offender to the guidelines outlined in this document,
chances are that people ignore you and your chances to get responses in the
future greatly diminish.

### Your emails are public

Your email, its contents and all its headers and the details in those headers
are received by every subscriber of the mailing list that you send your email
to.

Your email as sent to a curl mailing list ends up in mail archives, on the
curl website and elsewhere, for others to see and read. Today and in the
future. In addition to the archives, the mail is sent out to thousands of
individuals. There is no way to undo a sent email.

When sending emails to a curl mailing list, do not include sensitive
information such as usernames and passwords; use fake ones, temporary ones or
just remove them completely from the mail. Note that this includes base64
encoded HTTP Basic auth headers.

This public nature of the curl mailing lists makes automatically inserted mail
footers about mails being "private" or "only meant for the recipient" or
similar even more silly than usual. Because they are absolutely not private
when sent to a public mailing list.

## Sending mail

### Reply or New Mail

Please do not reply to an existing message as a short-cut to post a message to
the lists.

Many mail programs and web archivers use information within mails to keep them
together as "threads", as collections of posts that discuss a certain subject.
If you do not intend to reply on the same or similar subject, do not just hit
reply on an existing mail and change the subject, create a new mail.

### Reply to the List

When replying to a message from the list, make sure that you do "group reply"
or "reply to all", and not just reply to the author of the single mail you
reply to.

We are actively discouraging replying to the single person by setting the
correct field in outgoing mails back asking for replies to get sent to the
mailing list address, making it harder for people to reply to the author only
by mistake.

### Use a Sensible Subject

Please use a subject of the mail that makes sense and that is related to the
contents of your mail. It makes it a lot easier to find your mail afterwards
and it makes it easier to track mail threads and topics.

### Do Not Top-Post

If you reply to a message, do not use top-posting. Top-posting is when you
write the new text at the top of a mail and you insert the previous quoted
mail conversation below. It forces users to read the mail in a backwards order
to properly understand it.

This is why top posting is so bad (in top posting order):

    A: Because it messes up the order in which people normally read text.
    Q: Why is top-posting such a bad thing?
    A: Top-posting.
    Q: What is the most annoying thing in email?

Apart from the screwed up read order (especially when mixed together in a
thread when someone responds using the mandated bottom-posting style), it also
makes it impossible to quote only parts of the original mail.

When you reply to a mail. You let the mail client insert the previous mail
quoted. Then you put the cursor on the first line of the mail and you move
down through the mail, deleting all parts of the quotes that do not add
context for your comments. When you want to add a comment you do so, inline,
right after the quotes that relate to your comment. Then you continue
downwards again.

When most of the quotes have been removed and you have added your own words,
you are done.

### HTML is not for mails

Please switch off those HTML encoded messages. You can mail all those funny
mails to your friends. We speak plain text mails.

### Quoting

Quote as little as possible. Just enough to provide the context you cannot
leave out.

### Digest

We allow subscribers to subscribe to the "digest" version of the mailing
lists. A digest is a collection of mails lumped together in one single mail.

Should you decide to reply to a mail sent out as a digest, there are two
things you MUST consider if you really, really cannot subscribe normally
instead:

Cut off all mails and chatter that is not related to the mail you want to
reply to.

Change the subject name to something sensible and related to the subject,
preferably even the actual subject of the single mail you wanted to reply to

### Please Tell Us How You Solved The Problem

Many people mail questions to the list, people spend some of their time and
make an effort in providing good answers to these questions.

If you are the one who asks, please consider responding once more in case one
of the hints was what solved your problems. The guys who write answers feel
good to know that they provided a good answer and that you fixed the problem.
Far too often, the person who asked the question is never heard from again,
and we never get to know if they are gone because the problem was solved or
perhaps because the problem was unsolvable.

Getting the solution posted also helps other users that experience the same
problem(s). They get to see (possibly in the web archives) that the suggested
fixes actually have helped at least one person.
