/********* Sample code generated by the curl command line tool **********
 * All curl_easy_setopt() options are documented at:
 * https://curl.se/libcurl/c/curl_easy_setopt.html
 ************************************************************************/
#include <curl/curl.h>

int main(int argc, char *argv[])
{
  CURLcode result;
  CURL *curl;
  curl_mime *mime1;
  curl_mimepart *part1;
  curl_mime *mime2;
  curl_mimepart *part2;
  struct curl_slist *slist1;

  mime1 = NULL;
  mime2 = NULL;
  slist1 = NULL;
  slist1 = curl_slist_append(slist1, "X-testheader-1: header 1");
  slist1 = curl_slist_append(slist1, "X-testheader-2: header 2");

  curl = curl_easy_init();
  curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L);
  curl_easy_setopt(curl, CURLOPT_BUFFERSIZE, 102400L);
  curl_easy_setopt(curl, CURLOPT_URL, "http://%HOSTIP:%HTTPPORT/we/want/%TESTNUMBER");
  mime1 = curl_mime_init(curl);
  part1 = curl_mime_addpart(mime1);
  curl_mime_data(part1, "value", CURL_ZERO_TERMINATED);
  curl_mime_name(part1, "name");
  part1 = curl_mime_addpart(mime1);
  mime2 = curl_mime_init(curl);
  part2 = curl_mime_addpart(mime2);
  curl_mime_filedata(part2, "%LOGDIR/test%TESTNUMBER.txt");
  part2 = curl_mime_addpart(mime2);
  curl_mime_filedata(part2, "%LOGDIR/test%TESTNUMBER.txt");
  curl_mime_encoder(part2, "8bit");
  curl_mime_type(part2, "magic/content");
  part2 = curl_mime_addpart(mime2);
  curl_mime_filedata(part2, "%LOGDIR/test%TESTNUMBER.txt");
  curl_mime_headers(part2, slist1, 1);
  slist1 = NULL;
  curl_mime_subparts(part1, mime2);
  mime2 = NULL;
  curl_mime_name(part1, "file");
  curl_easy_setopt(curl, CURLOPT_MIMEPOST, mime1);
  curl_easy_setopt(curl, CURLOPT_USERAGENT, "curl/%VERSION");
  curl_easy_setopt(curl, CURLOPT_MAXREDIRS, 50L);
  curl_easy_setopt(curl, CURLOPT_TCP_KEEPALIVE, 1L);

  /* Here is a list of options the curl code used that cannot get generated
     as source easily. You may choose to either not use them or implement
     them yourself.

  CURLOPT_DEBUGFUNCTION was set to a function pointer
  CURLOPT_DEBUGDATA was set to an object pointer
  CURLOPT_WRITEDATA was set to an object pointer
  CURLOPT_WRITEFUNCTION was set to a function pointer
  CURLOPT_READDATA was set to an object pointer
  CURLOPT_READFUNCTION was set to a function pointer
  CURLOPT_SEEKDATA was set to an object pointer
  CURLOPT_SEEKFUNCTION was set to a function pointer
  CURLOPT_HEADERFUNCTION was set to a function pointer
  CURLOPT_HEADERDATA was set to an object pointer
  CURLOPT_ERRORBUFFER was set to an object pointer
  CURLOPT_STDERR was set to an object pointer

  */

  result = curl_easy_perform(curl);

  curl_easy_cleanup(curl);
  curl = NULL;
  curl_mime_free(mime1);
  mime1 = NULL;
  curl_mime_free(mime2);
  mime2 = NULL;
  curl_slist_free_all(slist1);
  slist1 = NULL;

  return (int)result;
}
/**** End of sample code ****/
